' [M !!PicoMite VGA / LCD (any screen size) "Scope_Auto F & V.bas"
' MODE 2  'can also use Mode 1 B&W
' Adjust trigger, gain, screen size, buffer size and speed to suit.

Dim Float Trig = 0 'Set trigger voltage, use "-" for falling trig. V, or 0 = Auto = mid screen
Dim Float Cycles = 2.5  'number of cycles to display in automatic mode
Dim Integer HRes = MM.HRes, VRes = MM.VRes 'Change if not using full screen area
Dim Integer buff = HRes * 6'10  'Capture buffer size - min = 2 x horiz. pixels
Dim Integer ADC_Hz = 0  'Set sampling rate (Hz) min 733, max 500000, or 0 = automatic
Dim Integer H.offset = HRes \ 12  'Adjust to view pre/post-trigger signal (+/- pixels)

Dim Integer TV, Auto_Hz = 0  'trigger voltage converted to pixels, Flag for auto ADC frequency
If (Trig > -.01) Or (Trig < .01) Then TV = VRes / 2 'switch to auto trigger voltage
Dim Integer Trig.sign = 1
If Trig < 0 Then Trig.sign = -1
Trig = Abs(Trig)
Dim Float Trg = Trig
Dim Integer  x, y, TC, TC2  'screen coordinates, Sample counters for triggering
Dim Float samples(buff) 'input buffer using OPTION BASE 0
Dim Float samples2(buff)  'output buffer
Dim Float Min, Max, p2p, TVa(2), TVb(2)  ' sample amplitudes, peak-to-peak value

If ADC_Hz = 0 Then : ADC_Hz = 10000 : Auto_Hz = 1 : EndIf ' set initial ADC_Hz for automatic adjustment

ADC open ADC_Hz, 1 'samples per second, GP26
CLS

Do
 samples(buff-1) = -1   'set last element to -1

 ADC start samples() 'get new samples + extra for trig. search
 Do While samples(buff-1) < 0 : Loop 'wait till array is full

 Math WINDOW samples(), VRes - 1, 0, samples2(), Min, Max 'Make samples fit screen, min at bottom, max at top
 p2p = Max - Min  'peak-to-peak sample values

 If (Min < Trig) And (Max > Trig) Then Trg = Trig

 If Trig <.01 Then  ' set auto trigger
   TV = VRes / 2
  Else           ' set manual trigger
   If Trig > Max Then Trg = Max - .01 'trig too high
   If Trig < Min Then Trg = Min + .01 'trig too low
   TVa(1) = Trg
   TVa(0) = Min : TVa(2) = Max
   Math WINDOW TVa(), VRes-1, 0, TVb() :TV = TVb(1)
 EndIf

 'search for Trigger Condition
 If H.offset > 0 Then TC = H.offset + 1 Else TC = 0 'allow for pre-trigger data

 If Trig.sign = 1 Then  'wait for signal to rise/fall through trigger voltage
   Do : Inc TC : Loop Until samples2(TC) > TV Or TC > buff - HRes
   Do : Inc TC : Loop Until samples2(TC) < TV Or TC > buff - HRes
  Else
   Do : Inc TC : Loop Until samples2(TC) < TV Or TC > buff - HRes
   Do : Inc TC : Loop Until samples2(TC) > TV Or TC > buff - HRes
 EndIf

 TC2 = TC + 1
 If Trig.sign = 1 Then  'wait for second rise/fall through trigger voltage
   Do : Inc TC2 : Loop Until samples2(TC2) > TV Or TC2 > buff - 2
   Do : Inc TC2 : Loop Until samples2(TC2) < TV Or TC2 > buff - 2
  Else
   Do : Inc TC2 : Loop Until samples2(TC2) < TV Or TC2 > buff - 2
   Do : Inc TC2 : Loop Until samples2(TC2) > TV Or TC2 > buff - 2
 EndIf

 If Auto_Hz Then  'Auto adjust ADC_Hz to display 'Cycles' across the screen
  ADC_Hz = ADC_Hz * HRes \ ((TC2 - TC) * Cycles)
  If ADC_Hz > 500000 Then ADC_Hz = 500000 'Max ADC_Hz
  If ADC_Hz < 733 Then ADC_Hz = 733 'Min ADC_Hz
  ADC Close
  ADC open ADC_Hz, 1 'samples per second, GP26
 EndIf

 Inc TC, -H.offset  'adjust for desired offset
 If TC > (buff-HRes) Or TC < 0 Then TC = 0 ' Trigger not found, plot from start

 'plot graticule

 For x = 0 To HRes
  If x Mod (HRes \ 8) Then
   If x < MM.Info(FONTWIDTH) * 37 Then
     Line x, MM.Info(FONTHEIGHT), x, VRes, 1, 0 'delete old trace except text area
    Else
     Line x, 0, x, VRes, 1, 0 'delete old trace
   EndIf
   Else
    Line x, 0, x, VRes, 1, 64<<8 'Time graticule
  EndIf

  For y= 0 To VRes-1 Step VRes/6
   Pixel x, y, 64<<8 'Voltage graticule
  Next

  Pixel x, TV, 192 'plot Trigger voltage level.
  Line H.offset, 0, H.offset, VRes, 1, 128 'plot trigger time

  'plot trace
  Line x, samples2(x+TC)-V.offset, x, samples2(x+1+TC)+V.offset,, RGB(64,64,64)
  Pixel x, samples2(x+TC)-V.offset, RGB(255,128,0)

  'Show voltages
  If x>MM.Info(FONTWIDTH)*6 Then
   Text 1,(Vres-MM.Info(FONTHEIGHT)),Str$(Min,1,3)+"V"
   Text 1,(Vres-MM.Info(FONTHEIGHT))\2,Str$((Max + Min)*.5,1,3)+"V"
  EndIf
 Next

 'Show signal data
 'Text 1, 1, Str$(max,1,3)+"V  "+Str$(p2p,1,3)+"Vp-p "+Str$(ADC_Hz\(TC2-TC-H.offset),1,0)+"Hz "+Str$(HRes*1000/8/ADC_Hz,1,4)+"mS/Div."
  Freq = ADC_Hz/(TC2-TC-H.offset) : mSpD = HRes*1000/8/ADC_Hz
  Text 1, 1, Str$(max,1,3)+"V  "+Str$(p2p,1,3)+"Vp-p "+Str$(Freq,1,1)+"Hz "+Str$(mSpD,1,3)+"mS/Div."
  Text HRes-MM.Info(FONTWIDTH)*4, TV-MM.Info(FONTHEIGHT)\2, Str$(Trg,1,2),,,,192 'Trigger voltage.

Loop
ADC close
End
                                                                         